/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.rm.WSUUIDGenFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.To;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.types.URI;

public class AddressingHandler
extends BasicHandler {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    private static final String m_className = "AddressingHandler";
    private static UUIDGen uuidGen = WSUUIDGenFactory.getUUIDGen();
    private List refPropQNames;
    private String actor;
    private boolean removeHeaders = false;

    public static String _get_FILE_DATE() {
        return "$Date:   16 Oct 2006 20:48:40  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.1  $";
    }

    public void init() {
        super.init();
        this.initializeReferencePropertyNames();
        this.initializeRemoveHeaders();
        this.initializeActor();
    }

    protected void initializeActor() {
        this.actor = (String)this.getOption("actor");
    }

    private void initializeRemoveHeaders() {
        String property = (String)this.getOption("removeHeaders");
        this.removeHeaders = "true".equalsIgnoreCase(property);
    }

    public void invoke(org.apache.axis.MessageContext msgContext) throws AxisFault {
        String m_method = "invoke";
        logger.entering(m_className, m_method);
        boolean setMustUnderstand = msgContext.isPropertyTrue("addressing.setMustUnderstand");
        try {
            if (msgContext.isClient()) {
                if (!msgContext.getPastPivot()) {
                    this.processClientRequest(msgContext, setMustUnderstand);
                } else {
                    this.processClientResponse(msgContext);
                }
            } else if (!msgContext.getPastPivot()) {
                this.processServerRequest(msgContext);
            } else {
                this.processServerResponse(msgContext, setMustUnderstand);
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw AxisFault.makeFault((Exception)e);
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public void onFault(org.apache.axis.MessageContext msgContext) {
        String m_method = "onFault";
        if (msgContext.isClient()) {
            return;
        }
        try {
            this.processFault(msgContext);
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
        }
    }

    protected void processFault(org.apache.axis.MessageContext msgContext) throws Exception {
        String uri;
        AttributedURI address;
        To toURI;
        AddressingHeaders reqHeaders = (AddressingHeaders)msgContext.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
        if (reqHeaders == null) {
            return;
        }
        AddressingHeaders resHeaders = AddressingUtils.getResponseHeaders((MessageContext)msgContext);
        EndpointReference fromEPR = resHeaders.getFrom();
        if (fromEPR == null && (toURI = reqHeaders.getTo()) != null) {
            fromEPR = new EndpointReference((URI)toURI);
            fromEPR.setProperties(reqHeaders.getReferenceProperties());
            resHeaders.setFrom(fromEPR);
        }
        resHeaders.setAction(new Action(new URI(AddressingUtils.getFaultActionURI())));
        MessageID msgID = reqHeaders.getMessageID();
        if (msgID != null) {
            resHeaders.addRelatesTo(msgID.toString(), AddressingUtils.getResponseRelationshipType());
        }
        msgID = new MessageID(new URI("uuid:" + uuidGen.nextUUID()));
        resHeaders.setMessageID(msgID);
        Message msg = msgContext.getCurrentMessage();
        if (msg == null) {
            return;
        }
        resHeaders.toEnvelope((SOAPEnvelope)msg.getSOAPEnvelope());
        EndpointReference faultTo = reqHeaders.getFaultTo();
        if (faultTo != null && (address = faultTo.getAddress()) != null && (uri = address.toString()) != null) {
            this.forwardMessage((EndpointReferenceType)faultTo, msg);
            msgContext.setCurrentMessage(null);
        }
    }

    protected void processClientRequest(org.apache.axis.MessageContext msgContext, boolean setMustUnderstand) throws Exception {
        String faultTo;
        String action;
        To to;
        AddressingHeaders sharedHeaders = (AddressingHeaders)msgContext.getProperty("org.apache.axis.message.addressing.SHARED_HEADERS");
        AddressingHeaders headers = AddressingUtils.getRequestHeaders((MessageContext)msgContext);
        headers.setSetMustUnderstand(setMustUnderstand);
        if (headers.getMessageID() == null) {
            MessageID id = new MessageID(new URI("uuid:" + uuidGen.nextUUID()));
            headers.setMessageID(id);
        }
        if ((to = headers.getTo()) == null) {
            if (sharedHeaders != null) {
                headers.setTo(sharedHeaders.getTo());
            } else {
                headers.setTo(new To(msgContext.getStrProp("transport.url")));
            }
        }
        if ((action = msgContext.getSOAPActionURI()) != null) {
            headers.setAction(new Action(new URI(action)));
        } else if (headers.getAction() != null) {
            msgContext.setUseSOAPAction(true);
            msgContext.setSOAPActionURI(headers.getAction().toString());
        }
        if (headers.getFrom() == null) {
            String from = msgContext.getStrProp("addressing.from.URI");
            if (from != null) {
                headers.setFrom(new EndpointReference(from));
            } else {
                headers.setFrom(new EndpointReference(AddressingUtils.getAnonymousRoleURI()));
            }
        }
        if (msgContext.isPropertyTrue("addressing.sendReplyTo") && headers.getReplyTo() == null) {
            String replyTo = msgContext.getStrProp("addressing.replyTo.URI");
            if (replyTo != null) {
                headers.setReplyTo(new EndpointReference(replyTo));
            } else {
                headers.setReplyTo(headers.getFrom());
            }
        }
        if (headers.getFaultTo() == null && (faultTo = msgContext.getStrProp("addressing.faultTo.URI")) != null) {
            headers.setFaultTo(new EndpointReference(faultTo));
        }
        if (sharedHeaders != null) {
            headers.setReferenceProperties(sharedHeaders.getReferenceProperties());
        }
        Message msg = msgContext.getRequestMessage();
        headers.toEnvelope((SOAPEnvelope)msg.getSOAPEnvelope(), this.actor);
    }

    protected void processClientResponse(org.apache.axis.MessageContext msgContext) throws Exception {
        Message msg = msgContext.getResponseMessage();
        if (msg == null) {
            return;
        }
        AddressingHeaders headers = new AddressingHeaders((SOAPEnvelope)msg.getSOAPEnvelope(), this.actor, true, this.removeHeaders, false, this.refPropQNames);
        msgContext.setProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS", (Object)headers);
    }

    protected void processServerRequest(org.apache.axis.MessageContext msgContext) throws Exception {
        String m_method = "processServerRequest";
        Message msg = msgContext.getRequestMessage();
        if (msg == null) {
            return;
        }
        AddressingHeaders headers = new AddressingHeaders((SOAPEnvelope)msg.getSOAPEnvelope(), this.actor, true, this.removeHeaders, false, this.refPropQNames);
        if (headers.getTo() == null) {
            return;
        }
        if (headers.getAction() == null && logger.isFinest()) {
            logger.finest(m_className, m_method, "WS-A request to endpoint " + headers.getTo() + " is missing the required wsa:Action header.");
        }
        msgContext.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)headers);
        if (msgContext.getService() == null && msgContext.getTargetService() == null) {
            this.setTargetService(msgContext, headers);
            if (msgContext.getService() != null) {
                this.resetOperations(msgContext);
            }
        }
    }

    protected void resetOperations(org.apache.axis.MessageContext msgContext) throws AxisFault {
        AddressingHandler.resetContextOperations(msgContext);
    }

    public static void resetContextOperations(org.apache.axis.MessageContext msgContext) throws AxisFault {
        Message msg = msgContext.getCurrentMessage();
        if (msg == null) {
            return;
        }
        org.apache.axis.message.SOAPEnvelope env = msg.getSOAPEnvelope();
        if (env == null) {
            return;
        }
        SOAPBodyElement bodyElement = env.getFirstBody();
        if (bodyElement != null && bodyElement instanceof RPCElement) {
            RPCElement element = (RPCElement)bodyElement;
            element.updateOperationsByQName();
            OperationDesc[] operations = element.getOperations();
            if (operations == null) {
                element.updateOperationsByName();
            } else if (operations.length == 1) {
                msgContext.setOperation(operations[0]);
            }
        } else {
            msg.getSOAPPartAsString();
        }
    }

    protected void setTargetService(org.apache.axis.MessageContext msgContext, AddressingHeaders headers) throws Exception {
        To toURI = headers.getTo();
        if (toURI == null) {
            return;
        }
        String to = toURI.getPath();
        if (to == null) {
            return;
        }
        int i = to.lastIndexOf(47);
        msgContext.setTargetService(to.substring(i + 1));
    }

    protected void processServerResponse(org.apache.axis.MessageContext msgContext, boolean setMustUnderstand) throws Exception {
        String uri;
        AttributedURI address;
        Action action;
        To toURI;
        Message msg = msgContext.getResponseMessage();
        if (msg == null) {
            return;
        }
        AddressingHeaders reqHeaders = (AddressingHeaders)msgContext.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
        if (reqHeaders == null) {
            return;
        }
        AddressingHeaders resHeaders = AddressingUtils.getResponseHeaders((MessageContext)msgContext);
        resHeaders.setSetMustUnderstand(setMustUnderstand);
        EndpointReference fromEPR = resHeaders.getFrom();
        if (fromEPR == null && (toURI = reqHeaders.getTo()) != null) {
            fromEPR = new EndpointReference((URI)toURI);
            fromEPR.setProperties(reqHeaders.getReferenceProperties());
            resHeaders.setFrom(fromEPR);
        }
        if ((action = resHeaders.getAction()) == null && (action = reqHeaders.getAction()) != null) {
            resHeaders.setAction(new Action(new URI(action.toString() + "Response")));
        }
        if (resHeaders.getFrom() == null && reqHeaders.getFrom() != null) {
            resHeaders.setTo(reqHeaders.getFrom().getAddress());
        } else {
            resHeaders.setTo(new To(AddressingUtils.getAnonymousRoleURI()));
        }
        MessageID msgID = null;
        msgID = reqHeaders.getMessageID();
        if (msgID != null) {
            resHeaders.addRelatesTo(msgID.toString(), AddressingUtils.getResponseRelationshipType());
        }
        msgID = new MessageID(new URI("uuid:" + uuidGen.nextUUID()));
        resHeaders.setMessageID(msgID);
        resHeaders.toEnvelope((SOAPEnvelope)msg.getSOAPEnvelope(), this.actor);
        EndpointReference replyTo = reqHeaders.getReplyTo();
        if (replyTo != null && (address = replyTo.getAddress()) != null && (uri = address.toString()) != null && !uri.equals(AddressingUtils.getAnonymousRoleURI())) {
            this.forwardMessage((EndpointReferenceType)replyTo, msg);
            msgContext.setResponseMessage(null);
        }
    }

    protected void forwardMessage(EndpointReferenceType epr, Message msg) throws Exception {
        AttributedURI address = epr.getAddress();
        AddressingHeaders headers = null;
        org.apache.axis.MessageContext msgContext = msg.getMessageContext();
        if (msgContext != null) {
            headers = (AddressingHeaders)msgContext.getProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS");
        }
        if (headers == null) {
            headers = new AddressingHeaders();
        }
        headers.setTo(address);
        headers.setReferenceProperties(epr.getProperties());
        Service service = this.getService(msgContext);
        Call c = (Call)service.createCall();
        c.setTargetEndpointAddress(address.toString());
        c.setRequestMessage(msg);
        c.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)headers);
        this.configureCall(c, msgContext);
        c.invoke();
    }

    protected Service getService(org.apache.axis.MessageContext msgContext) {
        return new Service();
    }

    protected void configureCall(Call call, org.apache.axis.MessageContext oldContext) {
    }

    private void initializeReferencePropertyNames() {
        String refPropNames = (String)this.getOption("referencePropertyNames");
        if (refPropNames == null) {
            this.refPropQNames = new ArrayList();
        } else if (refPropNames.equals("*")) {
            this.refPropQNames = null;
        } else {
            this.refPropQNames = new ArrayList();
            StringTokenizer tkn = new StringTokenizer(refPropNames, ",");
            while (tkn.hasMoreTokens()) {
                String qnameString = tkn.nextToken().trim();
                try {
                    QName qname = QName.valueOf(qnameString);
                    this.refPropQNames.add(qname);
                }
                catch (Exception e) {}
            }
        }
    }
}

